unit u_numstrings;

{$mode objfpc}{$H+}

interface

uses SysUtils;

function FIval(InpStr: string): longint;
function FRval(InpStr: string): real;
function StrLittleToUnsignedLong(InpStr: string):longint;
function StrLittleToUnSignedInt(InpStr: string):integer;
function StrLittleToSignedInt(InpStr: string):integer;
function LongLittleToString(InpLong: longint):shortstring;
function IntLittleToString(InpInt: integer):shortstring;
function BytesView(InpStr: string; Nch: integer): string;

implementation

{ convert string with Little Endian longint32 to unsigned longint32 }
function StrLittleToUnsignedLong(InpStr: string):longint;
var Temp: Longint;
begin
  Temp := ord(InpStr[4]);
  Temp := Temp*256 + ord(InpStr[3]);
  Temp := Temp*256 + ord(InpStr[2]);
  Temp := Temp*256 + ord(InpStr[1]);
  StrLittleToUnsignedLong:= Temp;
  // still work on negative values
end;

{ convert string with Little Endian int16 to unsigned int16 }
function StrLittleToUnSignedInt(InpStr: string): integer;
var Temp: Longint;
begin
  Temp := ord(InpStr[1]) + ord(Inpstr[2]) * 256;
  StrLittleToUnSignedInt := Temp;
end;

{ convert string with Little Endian int16 to signed int16 }
function StrLittleToSignedInt(InpStr: string): integer;
var Temp: Longint;
begin
  Temp := ord(InpStr[1]) + ord(Inpstr[2]) * 256;
  if Temp > 32767 then Temp := Temp - longint(65536);
  StrLittleToSignedInt := Temp;
end;

{ convert Little Endian longint32 to string }
function LongLittleToString(InpLong: longint):shortstring;
var Tempstr:shortstring;
begin
  TempStr[0] := char(4); // length byte
  TempStr[1] := char(InpLong and $000000FF);
  TempStr[2] := char((InpLong and $0000FF00) >> 8);
  TempStr[3] := char((InpLong and $00FF0000) >> 16);
  TempStr[4] := char((InpLong and $FF000000) >> 24);
  LongLittleToString := TempStr;
end;

{ convert Little Endian int16 to string }
function IntLittleToString(InpInt: integer):shortstring;
var Tempstr:shortstring;
begin
  TempStr[0] := char(2); // length byte
  TempStr[1] := char(InpInt and $00FF);
  TempStr[2] := char((InpInt and $FF00) >> 8);
  IntLittleToString := TempStr;
end;

function BytesView(InpStr: string; Nch: integer): string;
var N, A: integer; Temp, Total: string;
begin
  Total:= '';
  for N := 1 to Nch do
  begin
    A := byte(InpStr[N]);
    str(A:3, Temp);
    if Temp[2] = ' ' then Temp[2] := '0';
    if Temp[1] = ' ' then Temp[1] := '0';
    Total := Total + Temp + ':';
  end;
  BytesView := Total;
end;

function FIval(InpStr: string): longint;
var Temp: longint;
begin
  val(InpStr, Temp);
  FIval:= Temp;
end;

function FRval(InpStr: string): real;
var Temp: real;
begin
  val(InpStr, Temp);
  FRval:= Temp;
end;

end.

